/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.event;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.LootEvent;
import dev.architectury.event.events.common.PlayerEvent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.phys.EntityHitResult;
import net.satisfy.brewery.registry.MobEffectRegistry;
import net.satisfy.brewery.util.BreweryLoottableInjector;
import org.jetbrains.annotations.Nullable;

public class CommonEvents {
    public static void init() {
        LootEvent.MODIFY_LOOT_TABLE.register(CommonEvents::onModifyLootTable);
        PlayerEvent.ATTACK_ENTITY.register(CommonEvents::onPlayerAttack);
    }

    public static void onModifyLootTable(LootDataManager tables, ResourceLocation id, LootEvent.LootTableModificationContext context, boolean builtin) {
        BreweryLoottableInjector.InjectLoot(id, context);
    }

    public static EventResult onPlayerAttack(Player player, Level level, Entity target, InteractionHand hand, @Nullable EntityHitResult result) {
        if (player.m_21023_((MobEffect)MobEffectRegistry.PROTECTIVETOUCH.get())) {
            CommonEvents.handleProtectiveTouch(level, target);
            return EventResult.interruptFalse();
        }
        if (player.m_21023_((MobEffect)MobEffectRegistry.HEALINGTOUCH.get())) {
            CommonEvents.handleHealingTouch(level, target);
            return EventResult.interruptFalse();
        }
        if (player.m_21023_((MobEffect)MobEffectRegistry.RENEWINGTOUCH.get())) {
            CommonEvents.handleRenewingTouch(level, target);
            return EventResult.interruptFalse();
        }
        if (player.m_21023_((MobEffect)MobEffectRegistry.TOXICTOUCH.get())) {
            CommonEvents.handleToxicTouch(level, target);
            return EventResult.pass();
        }
        if (player.m_21023_((MobEffect)MobEffectRegistry.LIGHTNING_STRIKE.get())) {
            CommonEvents.handlelightningStrike(level, target);
            return EventResult.pass();
        }
        if (player.m_21023_((MobEffect)MobEffectRegistry.EXPLOSION.get())) {
            CommonEvents.handleExplosiveTouch(level, target, player);
            return EventResult.pass();
        }
        return EventResult.pass();
    }

    private static void handleRenewingTouch(Level level, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1));
            CommonEvents.spawnParticles(level, (Entity)entity, (ParticleOptions)ParticleTypes.f_123749_);
        }
    }

    private static void handleProtectiveTouch(Level level, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 200, 1));
            CommonEvents.spawnParticles(level, (Entity)entity, (ParticleOptions)ParticleTypes.f_175826_);
        }
    }

    private static void handleToxicTouch(Level level, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 300, 2));
            CommonEvents.spawnParticles(level, (Entity)entity, (ParticleOptions)ParticleTypes.f_175831_);
        }
    }

    private static void handleHealingTouch(Level level, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            ((LivingEntity)target).m_5634_(6.0f);
            CommonEvents.spawnParticles(level, (Entity)entity, (ParticleOptions)ParticleTypes.f_123750_);
        }
    }

    private static void handlelightningStrike(Level level, Entity target) {
        float chance;
        float f = chance = level.m_46470_() ? 0.75f : 0.1f;
        if (level.f_46441_.m_188501_() < chance) {
            LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, level);
            lightningBolt.m_6027_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            level.m_7967_((Entity)lightningBolt);
        }
    }

    private static void handleExplosiveTouch(Level level, Entity target, Player player) {
        if ((double)level.f_46441_.m_188501_() < 0.1) {
            Fireball fireball = (Fireball)EntityType.f_20463_.m_20615_(level);
            double dx = target.m_20185_() - player.m_20185_();
            double dy = target.m_20186_() + (double)(target.m_20206_() / 2.0f) - (player.m_20186_() + (double)(player.m_20206_() / 2.0f));
            double dz = target.m_20189_() - player.m_20189_();
            assert (fireball != null);
            fireball.m_6034_(player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20189_());
            fireball.m_6686_(dx, dy, dz, 1.5f, 0.0f);
            level.m_7967_((Entity)fireball);
        }
    }

    private static void spawnParticles(Level level, Entity target, ParticleOptions particleType) {
        double height = target.m_20206_();
        double x = target.m_20185_();
        double y = target.m_20186_();
        double z = target.m_20189_();
        for (double i = 2.5; i >= 1.5; i -= 0.5) {
            level.m_7106_(particleType, x, y + height / i, z, 0.0, 0.0, 0.0);
        }
    }
}

